#include "tokenreader.h"
#include <ctype.h>
#include <string.h>
#include <stdio.h>

// ctor
TokenReader::TokenReader( )
{

}

TokenReader::TokenReader( char* data )
{
	// stuff it
	token_stuffed = false;

	// copy it.
	data_pointer = data;

}

// dtor
TokenReader::~TokenReader( )
{


}

// peek string.
void TokenReader::peekstring( char* buffer, int len )
{
	// read until buffer is full.
	char ch = get();
	while( ch != '\0' && len > 1 )
	{
		// store.
		*buffer = ch;
		buffer++;
		len--;

		// fetch next
		ch = get();

	}

}


// skip whitespace.
void TokenReader::SkipWhiteSpace( )
{
	// skip whitespace.
	while( true )
	{
		// fetch.
		char ch = get();

		// whitespace?
		switch( ch )
		{
			// whitespace, ignore.
			case ' ':
			case '\t':
			case '\r':
			case '\n':
				break;

			// not whitespace.. or eof.
			case '\0':
			default:
				putback();

				return;

		}

	}

}

// get string
void TokenReader::GetString( char* buffer, int maxsize )
{
	// read char!!
	char ch = get();
	maxsize--;

	// append to buffer.
	while( ch != '\0' && ch != '\"' && maxsize > 1 )
	{
		// add.
		*buffer = ch;
		buffer++;

		// read next
		ch = get();
		maxsize--;

	}

	// ran out of room.. read past.
	if( maxsize < 1 )
	{
		ignore( '\"' );

	}

	// terminate it.
	*buffer = '\0';

}


// read token.
Token TokenReader::ReadToken( char* buffer, int maxsize )
{
	// return the stuffed token if there is one.
	if( token_stuffed )
	{
		strncpy( buffer, stuffed_data, maxsize );
		token_stuffed = false;
		return stuffed_token;

	}

	// skip whitespace
	SkipWhiteSpace();

	// read a character.
	char ch = get();

	// eof?
	if( ch == '\0' )
	{
		return TOKEN_EOF;

	}

	// operator?
	switch (ch)
	{
		case '@':
		case ',':
		case '!':
		case '+':
		case '&':
		case '*':
		case '$':
		case '.':
		case '=':
		case ':':
		case '[':
		case ']':
		case '(':
		case ')':
		case '{':
		case '}':
		case '\\':
			buffer[0] = ch;
			buffer[1] = '\0';
			return TOKEN_OPERATOR;

	};


	// single line comment?
	if( ch == '/' && peek() == '/' )
	{
		// consume the next slash.
		consume( 1 );

		// read next
		ch = get();

		// read the comment.
		while( ch != '\n' || ch == '\0' )
		{
			// ran out of room?
			if( maxsize < 1 )
			{
				*buffer = '\0';
				return TOKEN_COMMENT;

			}

			// add
			*buffer = ch;
			buffer++;
			maxsize--;

			// read next.
			ch = get();

		}

		// worthy.
		putback();

		// terminate it.
		*buffer = '\0';
		return TOKEN_COMMENT;

	}


	// multiline comments.
	if( ch == '/' && peek() == '*' )
	{
		// consume the comment.
		consume( 1 );

		// read next
		ch = get();

		// read the comment.
		while( !( ch == '*' && peek() == '/' ) )
		{
			// add
			if( maxsize >= 1 )
			{
				*buffer = ch;
				buffer++;
				maxsize--;

			}

			// read next.
			ch = get();

		}

		// consume the comment !
		consume( 1 );

		// terminate it.
		*buffer = '\0';
		return TOKEN_COMMENT;

	}


	// string?
	if( ch == '\"' )
	{
		GetString( buffer, maxsize );
		return TOKEN_STRING;

	}


	// number?
	if( isdigit( ch ) || ch == '-' )
	{
		do
		{
			// ran out of room?
			if( maxsize < 1 )
			{
				*buffer = '\0';
				return TOKEN_NUMBER;

			}

			// add
			*buffer = ch;
			buffer++;
			maxsize--;

			// read next
			ch = get();
			if( ch == '-' )
			{
				return TOKEN_ERROR;

			}

		} while( isdigit( ch ) || ch == '.' );

		// put it back
		putback();

		// number!
		*buffer = '\0';
		return TOKEN_NUMBER;

	}

	
	// identifer.
	while( isalpha( ch ) || isdigit( ch ) || ch == '_' )
	{
		// ran out of room?
		if( maxsize < 1 )
		{
			*buffer = '\0';
			return TOKEN_IDENTIFIER;

		}

		// add
		*buffer = ch;
		buffer++;
		maxsize--;

		// next
		ch = get();

	}

	// worthy
	// FIXME: Why does leaving this sometimes cause an infinite loop?
	//putback();

	// identifer.
	*buffer = '\0';
	return TOKEN_IDENTIFIER;

}




